      SUBROUTINE DCFFTF(N,C,WSAVE)  
C***BEGIN PROLOGUE  DCFFTF
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  860115   (YYMMDD)    
C***CATEGORY NO.  J1A2   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  Forward transform of a complex, periodic sequence.  
C***DESCRIPTION
C           From the book, "Numerical Methods and Software" by
C                D. Kahaner, C. Moler, S. Nash
C                Prentice Hall, 1988
C    
C  Subroutine DCFFTF computes the forward complex discrete Fourier
C  transform (the Fourier analysis).  Equivalently, DCFFTF computes    
C  the Fourier coefficients of a complex periodic sequence. 
C  The transform is defined below at output parameter C.    
C    
C  The transform is not normalized.  To obtain a normalized transform 
C  the output must be divided by N.  Otherwise a call of DCFFTF   
C  followed by a call of DCFFTB will multiply the sequence by N.  
C    
C  The array WSAVE which is used by subroutine DCFFTF must be
C  initialized by calling subroutine DCFFTI(N,WSAVE).   
C    
C  Input Parameters 
C    
C    
C  N      the length of the complex sequence C.  The method is   
C         more efficient when N is the product of small primes.  
C    
C  C      a complex array of length N which contains the sequence
C    
C  WSAVE   a d.p. work array which must be dimensioned at least 4*N+15
C          in the program that calls DCFFTF.  The WSAVE array must be  
C          initialized by calling subroutine DCFFTI(N,WSAVE), and a    
C          different WSAVE array must be used for each different 
C          value of N.  This initialization does not have to be  
C          repeated so long as N remains unchanged.  Thus subsequent  
C          transforms can be obtained faster than the first.
C          The same WSAVE array can be used by DCFFTF and DCFFTB.  
C    
C  Output Parameters
C    
C  C      for J=1,...,N  
C    
C             C(J)=the sum from K=1,...,N of 
C    
C                   C(K)*EXP(-I*J*K*2*PI/N)  
C    
C                         where I=SQRT(-1)   
C    
C  WSAVE   contains initialization calculations which must not be
C          destroyed between calls of subroutine DCFFTF or DCFFTB  
C    
C  *   References                                                      *   
C  *                                                                   *   
C  *   1. P.N. Swarztrauber, Vectorizing the FFTs, in Parallel         *   
C  *      Computations (G. Rodrigue, ed.), Academic Press, 1982,       *   
C  *      pp. 51-83.                                                   *   
C  *   2. B.L. Buzbee, The SLATEC Common Math Library, in Sources      *   
C  *      and Development of Mathematical Software (W. Cowell, ed.),   *   
C  *      Prentice-Hall, 1984, pp. 302-318.                            *   
C  *                                                                   *   
C  *********************************************************************   
C    
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DCFTF1   
C***END PROLOGUE  DCFFTF  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       C(*)       ,WSAVE(*)   
C***FIRST EXECUTABLE STATEMENT  DCFFTF   
      IF (N .EQ. 1) RETURN    
      IW1 = N+N+1   
      IW2 = IW1+N+N 
      CALL DCFTF1 (N,C,WSAVE,WSAVE(IW1),WSAVE(IW2))    
      RETURN   
      END 
